var bTitle = true;
var bLegend = true;
var bPercent = false;
var nGutter = -1;		/* Gutter override */
var bLegendFloat = false;

function rgAutoSize(canvas)
{	window.onresize = function () { location.reload(); }

	width = window.innerWidth - 8;
	height = window.innerHeight - 8;

	document.getElementById(canvas).setAttribute("width", width); 
	document.getElementById(canvas).setAttribute("height", height);
}

function rgDraw(oChart, bAnimate)
{	var		width;
	var		height;
	var		nAngle =0;
	var		oCanvas;
	
	oCanvas = document.getElementById(oChart.id);
	
	width = oCanvas.getAttribute("width");
	height = oCanvas.getAttribute("height");
	
	if (width < 400) nAngle = 45;

	var nFontsz = Math.min(height, width, 250);
	nFontsz = Math.max(5, Math.floor(nFontsz / 25));

	oChart.Set('gutter.top', 22 + nFontsz * 2)
		.Set('gutter.bottom', 20 + nFontsz * 2)
		.Set('gutter.left', width/10)
		.Set('gutter.right', Math.min(25, width/10))
		.Set('title.y', nFontsz * 2)
		.Set('key.position.y', 5 + nFontsz * 2 )
		.Set('text.angle', nAngle)
		.Set('text.size', nFontsz)
		.Set('title.size', nFontsz+1)
		.Set('title.xaxis.size', nFontsz+1)
		.Set('labels.above.size', nFontsz+1)
		.Set('title.yaxis.size', nFontsz+1);
	
	rgLoadTips(oChart);
	
	if (!bTitle)
	{	oChart.Set('title', '');
		oChart.Set('gutter.top', oChart.Get('gutter.top') - oChart.Get('title.size'));
	}
	if (!bLegend)
	{	oChart.Set('key', []);
	}
	else
	if (bLegendFloat)
	{	oChart.Set('key.position', 'graph');
		oChart.Set('gutter.right', oChart.Get('gutter.right') * 3);
	}
	
	if (nGutter != -1)
	{	oChart.Set('gutter.top', nGutter);
		oChart.Set('gutter.bottom', nGutter);
		oChart.Set('gutter.left', nGutter);
		oChart.Set('gutter.right', nGutter);
	}
	
/*	if (oChart.type == 'pie')
	{	//oCanvas.setAttribute("width", width / 1.5);
		//oCanvas.setAttribute("height", height * 1.5);
		oChart.Set('width',width / 1.2);
		oChart.Set('height', height * 1.2);
		oChart.Set('shadow.offsety', 15)
			.Set('shadow.offsetx', 0)
			.Set('shadow.color', '#aaa')
			.Set('shadow.blur', 0);
		oChart.context.setTransform(1.2,0,0,1,((oChart.canvas.width * 1.2) - oChart.canvas.width) * -0.2,0);
	}
*/	
	if ((bAnimate) && (typeof RGraph.Effects != 'undefined'))
	{	if (oChart.type == 'pie')
		{	RGraph.Effects.Pie.RoundRobin(oChart);
			return oChart;
		}
		if (oChart.type == 'bar')
		{	RGraph.Effects.Bar.Grow(oChart);
			return oChart;
		}
	}
	
	oChart.Draw();
	return oChart;
}

function rgLoadTips(oChart)
{	var	aryValues = oChart.data;
	if (!(aryValues instanceof Array)) return;
	
	if (aryValues.length == 0) return;
	var	aryKeys = oChart.Get('key');
	var aryLabels = oChart.Get('labels');
	
	var sValue;
	var sValueSfx = '';
	
	var aryTip = new Array();

	var nTotal = 0;
	
	if ((oChart.type == 'pie') && (bPercent))
	{	for (var s = 0; s < aryValues.length; s++)
		{	if (aryValues[s] < 0)
				aryValues[s] = 0;
			else
				nTotal += aryValues[s];
		}
		
		if (nTotal != 0)
		{	for (var s = 0; s < aryValues.length; s++)
			{	aryValues[s] = Math.round((100 * 100 * aryValues[s]) / nTotal) / 100;
			}
		}
		sValueSfx = '%';
	}
		
	for (var s = 0; s < aryValues.length; s++)
	{	sValue = aryValues[s];
		if (sValue instanceof Array)
		{	for (var i = 0; i < sValue.length; i++)
				aryTip.push( (aryLabels ? '<b><u>'+aryLabels[i]+'</u></b><br />' : '')+(aryKeys ? aryKeys[i]+": ": "")+sValue[i] + sValueSfx);
		}
		else
		{	aryTip.push('<b><u>'+(aryKeys ? aryKeys[s] : aryLabels[s])+'</u></b><br/>'+sValue + sValueSfx);
		}
	}

	oChart.Set('tooltips', aryTip);
	oChart.Set('tooltips.event', 'onmousemove');
}

		
